<?php
include('Db_connection.php');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET,HEAD,OPTIONS,POST,PUT");
header("Access-Control-Allow-Headers: *");

$status;

// --- Audit Function ---
function logAudit($db_connection, $action, $entity, $entity_id, $performed_by, $details = null) {
    $stmt = $db_connection->prepare("INSERT INTO audit_trail (action, entity, entity_id, performed_by, details) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("sssss", $action, $entity, $entity_id, $performed_by, $details);
    $stmt->execute();
    $stmt->close();
}

// --- Upload Code ---
$targetDir = "../uploads/";
if (!is_dir($targetDir)) {
    mkdir($targetDir, 0775, true);
}
// --- End Upload Code ---

// -------------------------
// Create Blood Unit
// -------------------------
if(isset($_POST['bloodDetails']) && !empty($_POST['bloodDetails'])){
    try{
        $unitID = mysqli_real_escape_string($db_connection,$_POST['bloodDetails']['unitID']);
        $bloodType = mysqli_real_escape_string($db_connection,$_POST['bloodDetails']['bloodType']);
        $volume = mysqli_real_escape_string($db_connection,$_POST['bloodDetails']['volume']);
        $donorName = mysqli_real_escape_string($db_connection,$_POST['bloodDetails']['donorName']);
        $donorID = mysqli_real_escape_string($db_connection,$_POST['bloodDetails']['donorID']??"");
        $donationDate = mysqli_real_escape_string($db_connection,$_POST['bloodDetails']['donationDate']);
        $notes = mysqli_real_escape_string($db_connection,$_POST['bloodDetails']['notes']??"");
        $expiryDate = mysqli_real_escape_string($db_connection,$_POST['bloodDetails']['expiryDate']);
        $storageLocation = mysqli_real_escape_string($db_connection,$_POST['bloodDetails']['storageLocation']);
        $screeningStatus = mysqli_real_escape_string($db_connection,$_POST['bloodDetails']['screeningStatus']);
        $batch_no = mysqli_real_escape_string($db_connection,$_POST['bloodDetails']['batch_no']);
        $availabilityStatus = (strcmp($screeningStatus,'passed')===0)?'Available':(strcmp($screeningStatus,'Pending')===0?'Pending':'Unavailable');
        $user = mysqli_real_escape_string($db_connection,$_POST['bloodDetails']['user']);

        $stmnt = $db_connection->prepare("INSERT INTO blood_units(type,volume,unit_code,donation_date,expiry_date,donor_name,donor_Id,storage_location,screening_status,availability_status,notes,created_by,batch_no) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmnt->bind_param("sisssssssssss",$bloodType,$volume,$unitID,$donationDate,$expiryDate,$donorName,$donorID,$storageLocation,$screeningStatus,$availabilityStatus,$notes,$user,$batch_no);
        $stmnt->execute();
        $stmnt->close();
        $status = 1;

        // --- Log Audit ---
        logAudit($db_connection, 'create', 'blood_unit', $unitID, $user, json_encode($_POST['bloodDetails']));

    } catch(Exception $dberr){
        $status = ($dberr->getCode()==1062) ? -1 : 0;
        print_r($dberr);
    }
    echo json_encode(['status'=>$status]);
}

// -------------------------
// Edit Blood Unit
// -------------------------
if(isset($_POST['editDetails']) && !empty($_POST['editDetails'])){
    try{
        $id = mysqli_real_escape_string($db_connection,$_POST['editDetails']['id']);
        $name = mysqli_real_escape_string($db_connection,$_POST['editDetails']['name']);
        $niaNo = mysqli_real_escape_string($db_connection,$_POST['editDetails']['niaNo']);
        $gender = mysqli_real_escape_string($db_connection,$_POST['editDetails']['gender']);
        $nhiaNo = mysqli_real_escape_string($db_connection,$_POST['editDetails']['nhiaNo']);
        $lhimsNo = mysqli_real_escape_string($db_connection,$_POST['editDetails']['opdNo']);
        $dob = mysqli_real_escape_string($db_connection,$_POST['editDetails']['dob']);

        $stmnt = $db_connection->prepare("UPDATE cards SET name=?,niaNo=?,gender=?,nhiaNo=?,opdNo=?,dob=?,updated_at=now() WHERE sysID=?");
        $stmnt->bind_param("sssisss",$name,$niaNo,$gender,$nhiaNo,$lhimsNo,$dob,$id);
        $stmnt->execute();
        $stmnt->close();
        $status = 1;

        logAudit($db_connection, 'update', 'card', $id, $name, json_encode($_POST['editDetails']));
    } catch(Exception $dberr){
        $status = 0;
    }
    echo json_encode(['status'=>$status]);
}

// -------------------------
// Delete Card
// -------------------------
if(isset($_POST['deleteCard']) && !empty($_POST['deleteCard'])){
    $sysId = mysqli_real_escape_string($db_connection,$_POST['deleteCard']);
    try{
        $stmnt = $db_connection->prepare("DELETE FROM cards WHERE sysID=?");
        $stmnt->bind_param("s",$sysId);
        $stmnt->execute();
        $stmnt->close();
        $status = 1;

        logAudit($db_connection, 'delete', 'card', $sysId, 'system');

    } catch(Exception $dberr){
        $status = 0;
    }
    echo json_encode(['status'=>$status]);
}

// -------------------------
// Issue Blood Unit
// -------------------------
if(isset($_POST['issueBloodUnit']) && !empty($_POST['issueBloodUnit'])){
    $data = $_POST['issueBloodUnit'];
    $serial_no = mysqli_real_escape_string($db_connection,$data['serialNo']);
    $newStatus = mysqli_real_escape_string($db_connection,$data['status']);
    $username = mysqli_real_escape_string($db_connection,$data['username']);
    $batch_no=mysqli_real_escape_string($db_connection,$data['batchNo']??'');
    $remarks=mysqli_real_escape_string($db_connection,$data['remarks']??'');
    $batch_no=mysqli_real_escape_string($db_connection,$data['batchNo']??'');
    $issuersInitials=mysqli_real_escape_string($db_connection,$data['issuersInitials']??'');

    $db_connection->begin_transaction();
    try {
        $stmt = $db_connection->prepare("INSERT INTO issuedbloodlogs (
                serial_no,
                date,
                opd_no,
                patient_name,
                department,
                age,
                sex,
                patient_group,
                batch_no,
                donor_group,
                date_of_x_match,
                received_by,
                time_received,
                remarks,
                issuers_initials,
                username
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ");
        $stmt->bind_param(
               'sssssissssssssss',
            $data['serialNo'],
            $data['date'],          
            $data['opdNo'],          
            $data['patientName'],
            $data['department'],
            $data['age'],           
            $data['sex'],
            $data['patientGroup'],
            $batch_no,
            $data['donorGroup'],
            $data['dateOfXmatch'],
            $data['receivedBy'],
            $data['timeReceived'],
            $remarks,
            $issuersInitials,
            $username
        );
        $stmt->execute();
        $stmt->close();

        $stmt2 = $db_connection->prepare("UPDATE blood_units SET availability_status=? WHERE unit_code=?");
        $stmt2->bind_param("ss",$newStatus,$serial_no);
        $stmt2->execute();
        $stmt2->close();

        $db_connection->commit();
        $status = 1;

        logAudit($db_connection, 'issue', 'blood_unit', $serial_no, $username, json_encode($data));

    } catch(Exception $e){
        $db_connection->rollback();
        $status = 0;
    }
    echo json_encode(['status'=>$status]);
}

// -------------------------
// Return Blood Unit
// -------------------------
if(isset($_POST['returnBloodUnit']) && !empty($_POST['returnBloodUnit'])){
    $data = $_POST['returnBloodUnit'];
    print_r($data);
    $serial_no = mysqli_real_escape_string($db_connection,$data['serialNo']);
    $newStatus = mysqli_real_escape_string($db_connection,$data['status']);
    $username = mysqli_real_escape_string($db_connection,$data['username']);
     $batch_no=mysqli_real_escape_string($db_connection,$data['batchNo']??'');
    $remarks=mysqli_real_escape_string($db_connection,$data['remarks']??'');
    $batch_no=mysqli_real_escape_string($db_connection,$data['batchNo']??'');
    $receiverInitials=mysqli_real_escape_string($db_connection,$data['receiverInitials']??'');



    $db_connection->begin_transaction();
    try {
        $stmt = $db_connection->prepare("INSERT INTO returnbloodlogs (serial_no,date,opd_no, patient_name, department, age, sex, patient_group, batch_no, donor_group, returned_by, time_returned, remarks, receiver_initials, username) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param(
            'sssssisssssssss',
            $data['serialNo'],$data['returnDate'], $data['opdNo'], $data['patientName'], $data['department'], $data['age'], $data['sex'], $data['patientGroup'], $batch_no, $data['donorGroup'], $data['returnedBy'], $data['returnDate'], $remarks, $receiverInitials, $username
        );
        $stmt->execute();
        $stmt->close();

        $stmt2 = $db_connection->prepare("UPDATE blood_units SET availability_status=? WHERE unit_code=?");
        $stmt2->bind_param("ss",$newStatus,$serial_no);
        $stmt2->execute();
        $stmt2->close();

        $db_connection->commit();
        $status = 1;

        logAudit($db_connection, 'return', 'blood_unit', $serial_no, $username, json_encode($data));

    } catch(Exception $e){
        print_r($e);
        $db_connection->rollback();
        $status = 0;
    }
    echo json_encode(['status'=>$status]);
}

// -------------------------
// Update Screening Status
// -------------------------
if(isset($_POST['updateScreeningStatus']) && !empty($_POST['updateScreeningStatus'])){
    try {
        $id = mysqli_real_escape_string($db_connection,$_POST['updateScreeningStatus']['id']);
        $newStatus = mysqli_real_escape_string($db_connection,$_POST['updateScreeningStatus']['status']);
        $availabilityStatus = mysqli_real_escape_string($db_connection,$_POST['updateScreeningStatus']['availability']);
        $exp = mysqli_real_escape_string($db_connection,$_POST['updateScreeningStatus']['exp']);
        $user = mysqli_real_escape_string($db_connection,$_POST['updateScreeningStatus']['user']??'system');

        $today = date('Y-m-d');
        $expiryDate = date('Y-m-d', strtotime($exp));
        if($expiryDate >= $today){
            $availabilityStatus = ($newStatus === "Passed") ? (($availabilityStatus === "Unavailable" || $availabilityStatus === "Pending")?"Available":$availabilityStatus) : "Unavailable";
        } else { $availabilityStatus = "Expired"; }

        $stmnt = $db_connection->prepare("UPDATE blood_units SET screening_status=?,availability_status=? WHERE unit_code=?");
        $stmnt->bind_param("sss",$newStatus,$availabilityStatus,$id);
        $stmnt->execute();
        $stmnt->close();
        $status = 1;

        logAudit($db_connection, 'update_screening', 'blood_unit', $id, $user, json_encode($_POST['updateScreeningStatus']));
    } catch(Exception $e){
        $status = 0;
    }
    echo json_encode(['status'=>$status]);
}

// -------------------------
// Discard Blood Unit
// -------------------------
if(isset($_POST['discardBloodUnit']) && !empty($_POST['discardBloodUnit'])){
    $data = $_POST['discardBloodUnit'];
    try{
        $stmt = $db_connection->prepare("INSERT INTO blood_disposal (date, serial_number, batch_number, blood_group, volume, product_type, reason_for_discard, initials, source_of_generation, supervising_officer_id, remarks) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->execute([
            $data['date'], $data['serial_number'], $data['batch_number'], $data['blood_group'], $data['volume'], $data['product_type'], $data['reason_for_discard'], $data['initials'], $data['source_of_generation'], $data['supervising_officer'], $data['remarks']??null
        ]);
        $stmt->close();
        $status = 1;

        logAudit($db_connection, 'discard', 'blood_unit', $data['serial_number'], $data['initials']??'system', json_encode($data));

    } catch(Exception $e){
        $status = 0;
    }
    echo json_encode(['status'=>$status]);
}

// -------------------------
// GET Endpoints
// -------------------------
// These remain untouched from your original file
// inventory, bloodUnit, issueBloodLogs, getIssuedBlood, getSupervisors, batchNo

// -------------------------
// GET Inventory
// -------------------------
if(isset($_GET['inventory'])){ 
  $inventory=array();
  $query="SELECT type,volume,unit_code,donation_date,expiry_date,donor_name,screening_status,availability_status,batch_no FROM blood_units";
  $run_query=mysqli_query($db_connection,$query);
  while($res=mysqli_fetch_array($run_query)){
      $inventory[]=array(
        'id'=>$res['unit_code'],
        'type'=>$res['type'],
        'donor'=>$res['donor_name'],
        'donation'=>$res['donation_date'],
        'expires'=>$res['expiry_date'],
        'volume'=>$res['volume'],
        'batchNo'=>$res['batch_no'],
        'screening'=>$res['screening_status'],
        'status'=>$res['availability_status']  
      );
  }
  echo json_encode($inventory,JSON_UNESCAPED_SLASHES);
}

// -------------------------
// GET Blood Unit
// -------------------------
if(isset($_GET['bloodUnit'])&&!empty($_GET['bloodUnit'])){ 
  $bloodUnit=mysqli_real_escape_string($db_connection,$_GET['bloodUnit']);
  $bloodData=array();
  $query="SELECT type,volume,unit_code,donation_date,expiry_date,donor_name,screening_status,availability_status,storage_location,batch_no FROM blood_units WHERE unit_code='$bloodUnit'";
  $run_query=mysqli_query($db_connection,$query);
  while($res=mysqli_fetch_array($run_query)){
      $bloodData=array(
        'id'=>$res['unit_code'],
        'type'=>$res['type'],
        'donor'=>$res['donor_name'],
        'donation'=>$res['donation_date'],
        'expires'=>$res['expiry_date'],
        'volume'=>$res['volume'],
        'screening'=>$res['screening_status'],
        'status'=>$res['availability_status'],  
        'storage'=>$res['storage_location'],  
        'batchNo'=>$res['batch_no'],
      );
  }
  echo json_encode($bloodData,JSON_UNESCAPED_SLASHES);
}

// -------------------------
// GET Issue Logs
// -------------------------
if(isset($_GET['issueBloodLogs'])){
    $sql = "SELECT id,serial_no,opd_no,patient_name,department,age,sex,patient_group,batch_no,donor_group,date_of_x_match,received_by,time_received,remarks,issuers_initials,username,batch_no FROM issuedbloodlogs ORDER BY id DESC";
    $result = mysqli_query($db_connection,$sql);
    $logs = [];
    while($row = mysqli_fetch_assoc($result)){
        $logs[] = $row;
    }
    echo json_encode($logs);
}

// -------------------------
// GET Issued Blood Details
// -------------------------
if(isset($_GET['getIssuedBlood'])&&!empty($_GET['getIssuedBlood'])){ 
    $bloodUnit=mysqli_real_escape_string($db_connection,$_GET['getIssuedBlood']);
    $issuedBloodDetails=array();
    $query="SELECT id,serial_no,opd_no,patient_name,department,age,sex,patient_group,batch_no,donor_group,date_of_x_match,received_by,time_received,remarks,issuers_initials,username FROM issuedbloodlogs WHERE serial_no='$bloodUnit'";
    $run_query=mysqli_query($db_connection,$query);
    while($res=mysqli_fetch_array($run_query)){
        $issuedBloodDetails=array(
            'serialNo'=>$res['serial_no'],
            'batchNo'=>$res['batch_no'],
            'patientName'=>$res['patient_name'],
            'age'=>$res['age'],
            'sex'=>$res['sex'],
            'department'=>$res['department'],
            'patientGroup'=>$res['patient_group'],
            'opdNo'=>$res['opd_no'],
            'dateXMatch'=>$res['date_of_x_match'],
            'donorGroup'=>$res['donor_group'],
            'timeReceived'=>$res['time_received'],
            'receivedBy'=>$res['received_by'],
            'initials'=>$res['issuers_initials'],
            'remarks'=>$res['remarks'],
        );
    }
    echo json_encode($issuedBloodDetails,JSON_UNESCAPED_SLASHES);
}

// -------------------------
// GET Supervisors
// -------------------------
if(isset($_GET['getSupervisors'])){
    $data=[];
    $result = $db_connection->query("SELECT id,name FROM supervising_officers ORDER BY name");
    while($row = $result->fetch_assoc()){ $data[] = $row; }
    echo json_encode($data);
}

// -------------------------
// GET Batch Number
// -------------------------
if(isset($_GET['batchNo'])){
    $currentYear = date('Y');
    $sql = "SELECT COUNT(*) AS total FROM blood_units WHERE YEAR(created_at) = ?";
    $stmt = mysqli_prepare($db_connection,$sql);
    mysqli_stmt_bind_param($stmt,"i",$currentYear);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $row = mysqli_fetch_assoc($result);
    echo json_encode($row['total']);
}
?>
