<?php
include('Db_connection.php');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET,HEAD,OPTIONS,POST,PUT");
header("Access-Control-Allow-Headers: *");

function queryError($db_connection, $message)
{
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => $message,
        "db_error" => $db_connection->error
    ]);
    exit;
}

// Only count usable blood
$sql = "
    SELECT type, COUNT(*) AS units
    FROM blood_units
    WHERE availability_status = 'Available'
    GROUP BY type
    ORDER BY type
";

$result = $db_connection->query($sql);

if (!$result) {
    queryError($db_connection, "Failed to fetch blood units by type");
}

$data = [];

while ($row = $result->fetch_assoc()) {
    $data[] = [
        "type" => $row['type'],
        "units" => (int)$row['units']
    ];
}

echo json_encode($data);


?>