<?php
include('Db_connection.php');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET,HEAD,OPTIONS,POST,PUT");
header("Access-Control-Allow-Headers: *");

function queryError($db_connection, $message)
{
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => $message,
        "db_error" => $db_connection->error
    ]);
    exit;
}

$response = [
    "status" => "success",
    "total_units" => 0,
    "available_units" => 0,
    "expiring_soon" => 0,
    "issued_today" => 0
];

// 1. Total units (Available OR Pending)
$sqlTotal = "
    SELECT COUNT(*) AS total
    FROM blood_units
    WHERE availability_status IN ('Available', 'Pending')
";
$result = $db_connection->query($sqlTotal);
if (!$result) {
    queryError($db_connection, "Failed to fetch total units");
}
$response['total_units'] = (int)$result->fetch_assoc()['total'];

// 2. Available units
$sqlAvailable = "
    SELECT COUNT(*) AS total
    FROM blood_units
    WHERE availability_status = 'Available'
";
$result = $db_connection->query($sqlAvailable);
if (!$result) {
    queryError($db_connection, "Failed to fetch available units");
}
$response['available_units'] = (int)$result->fetch_assoc()['total'];

// 3. Expiring soon (next 14 days)
$sqlExpiring = "
    SELECT COUNT(*) AS total
    FROM blood_units
    WHERE expiry_date BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 14 DAY)
";
$result = $db_connection->query($sqlExpiring);
if (!$result) {
    queryError($db_connection, "Failed to fetch expiring units");
}
$response['expiring_soon'] = (int)$result->fetch_assoc()['total'];

// 4. Issued today
$sqlIssuedToday = "
    SELECT COUNT(*) AS total
    FROM issuedbloodlogs
    WHERE DATE(created_at) = CURDATE()
";
$result = $db_connection->query($sqlIssuedToday);
if (!$result) {
    queryError($db_connection, "Failed to fetch issued blood today");
}
$response['issued_today'] = (int)$result->fetch_assoc()['total'];

// return success response
echo json_encode($response);

?>