<?php
include('Db_connection.php');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET,HEAD,OPTIONS,POST,PUT");
header("Access-Control-Allow-Headers: *");
header("Content-Type: application/json");

/*
 

$where = [];
$params = [];

if (!empty($_GET['blood_group'])) {
  $where[] = "blood_group = ?";
  $params[] = $_GET['blood_group'];
}

if (!empty($_GET['from']) && !empty($_GET['to'])) {
  $where[] = "date BETWEEN ? AND ?";
  $params[] = $_GET['from'];
  $params[] = $_GET['to'];
}

$sql = "SELECT b.*, u.name AS officer
FROM blood_disposal b
LEFT JOIN users u ON b.supervising_officer_id = u.id";

if ($where) $sql .= " WHERE " . implode(" AND ", $where);

$stmt = $db_connection->prepare($sql);
$stmt->execute($params);
$result=$stmt->get_result();
echo json_encode($result->fetch_all(MYSQLI_ASSOC));
 */
$page  = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 10;
$search = isset($_GET['search']) ? trim($_GET['search']) : "";
$startDate = $_GET['startDate'] ?? null;
$endDate   = $_GET['endDate'] ?? null;

$offset = ($page - 1) * $limit;

// Base WHERE clause
$where = "WHERE 1=1";
$params = [];
$types = "";

// Search filter
if (!empty($search)) {
    $where .= " AND (
        serial_number LIKE ? OR
        date LIKE ? OR
        blood_group LIKE ? OR
        source_of_generation LIKE ? OR
        reason_for_discard LIKE ? OR
        initials LIKE ?
    )";
    for ($i = 0; $i < 6; $i++) {
        $params[] = "%$search%";
        $types .= "s";
    }
}

// Date range filter
if ($startDate && $endDate) {
    $where .= " AND date BETWEEN ? AND ?";
    $params[] = $startDate;
    $params[] = $endDate;
    $types .= "ss";
}

// -------- Total count --------
$countSql = "SELECT COUNT(*) as total FROM blood_disposal $where";
$countStmt = $db_connection->prepare($countSql);
if ($types) {
    $countStmt->bind_param($types, ...$params);
}
$countStmt->execute();
$totalResult = $countStmt->get_result()->fetch_assoc();
$total = $totalResult['total'];

// -------- Data query --------
$dataSql = "
    SELECT b.*,u.name AS officer
FROM blood_disposal b
LEFT JOIN supervising_officers u ON b.supervising_officer_id = u.id
    $where
    ORDER BY date DESC
    LIMIT ? OFFSET ?
";



$dataStmt = $db_connection->prepare($dataSql);

// Bind params + limit/offset
if ($types) {
    $typesWithLimit = $types . "ii";
    $paramsWithLimit = array_merge($params, [$limit, $offset]);
    $dataStmt->bind_param($typesWithLimit, ...$paramsWithLimit);
} else {
    $dataStmt->bind_param("ii", $limit, $offset);
}

$dataStmt->execute();
$result = $dataStmt->get_result();

$data = [];
while ($row = $result->fetch_assoc()) {
    $data[] = $row;
}

// -------- Response --------
echo json_encode([
    "status" => "success",
    "data"   => $data,
    "total"  => $total,
    "page"   => $page,
    "limit" => $limit
]);
