<?php
include('Db_connection.php');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET,HEAD,OPTIONS,POST,PUT");
header("Access-Control-Allow-Headers: *");

$response = [
    "status" => "success",
    "data" => [],
    "error" => null
];

try {
    $sql = "
        SELECT 
            unit_code AS serial,
            DATEDIFF(expiry_date, CURDATE()) AS days_remaining
        FROM blood_units
        WHERE availability_status = 'Available'
          AND expiry_date BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 14 DAY)
        ORDER BY RAND()
        LIMIT 10
    ";

    $result = $db_connection->query($sql);

    if (!$result) {
        throw new Exception("Failed to fetch expiring available blood units");
    }

    while ($row = $result->fetch_assoc()) {
        $response['data'][] = [
            "serial" => $row['serial'],
            "days_remaining" => (int)$row['days_remaining']
        ];
    }

} catch (Exception $e) {
    http_response_code(500);

    $response['status'] = "error";
    $response['error'] = [
        "message" => $e->getMessage(),
        "db_error" => $db_connection->error
    ];

    // Error boundary fallback
    $response['data'] = [];
}

echo json_encode($response);



?>