<?php
include('Db_connection.php');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET,HEAD,OPTIONS,POST,PUT");
header("Access-Control-Allow-Headers: *");
header("Content-Type: application/json");


$page  = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 10;
$search = isset($_GET['search']) ? trim($_GET['search']) : "";
$startDate = $_GET['startDate'] ?? null;
$endDate   = $_GET['endDate'] ?? null;

$offset = ($page - 1) * $limit;

// Base WHERE clause
$where = "WHERE 1=1";
$params = [];
$types = "";

// Search filter
if (!empty($search)) {
    $where .= " AND (
        serial_no LIKE ? OR
        opd_no LIKE ? OR
        date LIKE ? OR
        patient_name LIKE ? OR
        department LIKE ? OR
        received_by LIKE ? OR
        username LIKE ?
    )";
    for ($i = 0; $i < 6; $i++) {
        $params[] = "%$search%";
        $types .= "s";
    }
}

// Date range filter
if ($startDate && $endDate) {
    $where .= " AND date_of_x_match BETWEEN ? AND ?";
    $params[] = $startDate;
    $params[] = $endDate;
    $types .= "ss";
}

// -------- Total count --------
$countSql = "SELECT COUNT(*) as total FROM issuedbloodlogs $where";
$countStmt = $db_connection->prepare($countSql);
if ($types) {
    $countStmt->bind_param($types, ...$params);
}
$countStmt->execute();
$totalResult = $countStmt->get_result()->fetch_assoc();
$total = $totalResult['total'];

// -------- Data query --------
$dataSql = "
    SELECT
        id,
        date,
        serial_no,
        opd_no,
        patient_name,
        department,
        age,
        sex,
        patient_group,
        batch_no,
        donor_group,
        date_of_x_match,
        received_by,
        time_received,
        remarks,
        issuers_initials,
        username
    FROM issuedbloodlogs
    $where
    ORDER BY date DESC, id DESC
    LIMIT ? OFFSET ?
";

$dataStmt = $db_connection->prepare($dataSql);

// Bind params + limit/offset
if ($types) {
    $typesWithLimit = $types . "ii";
    $paramsWithLimit = array_merge($params, [$limit, $offset]);
    $dataStmt->bind_param($typesWithLimit, ...$paramsWithLimit);
} else {
    $dataStmt->bind_param("ii", $limit, $offset);
}

$dataStmt->execute();
$result = $dataStmt->get_result();

$data = [];
while ($row = $result->fetch_assoc()) {
    $data[] = $row;
}

// -------- Response --------
echo json_encode([
    "status" => "success",
    "data"   => $data,
    "total"  => $total,
    "page"   => $page,
    "limit" => $limit
]);
