<?php
include('Db_connection.php');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET,HEAD,OPTIONS,POST,PUT");
header("Access-Control-Allow-Headers: *");

$status;


//Upload Code
$targetDir = "../uploads/";
if (!is_dir($targetDir)) {
    mkdir($targetDir, 0775, true);
}
//End Upload Code
//GET PRODUCTS
if(isset($_GET['products'])){ 
  $products=array();
  try{
    $products_query="SELECT * FROM products";
    $run_query=mysqli_query($db_connection,$products_query);
    while($res=mysqli_fetch_array($run_query)){
      $products[]=array(
        'id'=>$res['productCode'],
        'title'=>$res['title'],
        'price'=>$res['price'],
        'quantity'=>(int)$res['quantity'],
        'description'=>$res['description'],
        'isPreorder'=>$res['isPreorder']==0?'No':'Yes',
        'views'=>(int) $res['views'],
        'image'=>$res['productImage'],
        'category'=>$res['category'],
        'bulk_desc'=>$res['bulk_description'],
        'bulk_price'=>$res['bulk_price']
      );
    
      

    }
echo json_encode($products,JSON_UNESCAPED_SLASHES);
  }catch(Exception $dberr){
    
  }  
}

//ADD A PRODUCT
if(isset($_POST['product']) && (!empty($_POST['product']))){
//print_r($_FILES);
//print_r($_POST);

  try{
  

    $filename='';
    if (isset($_FILES["product"])) {

      $newFilename=time().basename($_FILES['product']["name"]['file']);
    
       $targetFile = $targetDir .$newFilename ;
       if (move_uploaded_file($_FILES["product"]["tmp_name"]['file'], $targetFile)) {
         $filename='https://primustechsolutions.online/uploads/'.$newFilename;
       }
      } 

    $stmnt=$db_connection->prepare("INSERT INTO cards(name, Designation, staffNo, nhiaNo, opdNo, photoId,  created_by, sysID, card_type) VALUES (?,?,?,?,?,?,?,?,?)");
    $stmnt->bind_param("sidsissssd",$title,$quantity,$price,$description,$isPreorder,$image,$category,$p_code,$blk_desc,$blk_price);
    
    $title=$_POST['product']['title'];
    $quantity=$_POST['product']['quantity'];
    $price=$_POST['product']['price'];
    $description=$_POST['product']['description'];
    $isPreorder=$_POST['product']['isPreorder'];
    $image=$filename;
    $category=$_POST['product']['category'];
    $p_code=sha1($_POST['product']['product_code']);
    $blk_desc=$_POST['product']['bulktext']??'';
    $blk_price=$_POST['product']['bulkPrice']??0.00;
    $stmnt->execute();
    $status=1;
    $stmnt->close();
  }catch(Exception $dberr){
    echo $dberr;
    $status=0;
  }
  echo json_encode(array('status'=>$status));
}





//GET A PRODUCT
if(isset($_POST['getProduct']) && (!empty($_POST['getProduct']))){
  $products=array();
  try{
    $products_query="SELECT * FROM products WHERE productCode='".$_POST['getProduct']."'";
    $run_query=mysqli_query($db_connection,$products_query);
    while($res=mysqli_fetch_array($run_query)){
      $products=array(     
        'id'=>$res['productCode'],     
        'title'=>$res['title'],
        'price'=>$res['price'],
        'quantity'=>(int)$res['quantity'],
        'description'=>$res['description'],
        'isPreorder'=>$res['isPreorder']==0?'No':'Yes',
        'views'=>(int) $res['views'],
        'image'=>$res['productImage'],
        'category'=>$res['category'],
        'bulk_desc'=>$res['bulk_description'],
        'bulk_price'=>$res['bulk_price']
      );
    
  }
//print_r($products);

  echo json_encode($products);
}catch(Exception $dberr){
  
}

}

//UPDATE A PRODUCT
if(isset($_POST['putProduct']) && (!empty($_POST['putProduct']))){  
    try{
      $stmnt=$db_connection->prepare("UPDATE products SET title=?,quantity=?,price=?,description=?,isPreorder=?,productImage=?,category=?,bulk_description=?,bulk_price=? WHERE productCode=?");
      $stmnt->bind_param("sidsisssds",$title,$quantity,$price,$description,$isPreorder,$image,$category,$blk_desc,$blk_price,$id);
      $title=$_POST['putProduct']['title'];
      $quantity=$_POST['putProduct']['quantity'];
      $price=$_POST['putProduct']['price'];
      $description=$_POST['putProduct']['description'];
      $isPreorder=$_POST['putProduct']['isPreorder'];
      $image=$_POST['putProduct']['image'];
      $category=$_POST['putProduct']['category'];
      $id=$_POST['putProduct']['id'];
      $blk_desc=$_POST['putProduct']['bulktext'];
      $blk_price=$_POST['putProduct']['bulkPrice']??0.00;
      $stmnt->execute();
      $status=1;
      $stmnt->close();
    }catch(Exception $dberr){
      echo $dberr;
      $status=0;
    }
    echo json_encode(array('status'=>$status));
}

//DELETE PRODUCT
if(isset($_POST['deleteProduct']) && (!empty($_POST['deleteProduct']))){
  //print_r($_POST);
  try{
    $stmnt=$db_connection->prepare("DELETE FROM products WHERE productCode=?");
    $stmnt->bind_param("s",$id);
    $id=$_POST['deleteProduct'];
    $stmnt->execute();
    $status=1;
    $stmnt->close();
  }catch(Exception $dberr){
    $status=0;
  }
  echo json_encode(array('status'=>$status));
}

//PRODUCT VIEWS
if(isset($_POST['view']) && (!empty($_POST['view']))){
  try{

    $stmnt=$db_connection->prepare("UPDATE products SET views=views+1 WHERE productCode=?");
      $stmnt->bind_param("s",$id);
      $id=$_POST['view'];
      $stmnt->execute();
      $status=1;
      $stmnt->close();
  }catch(Exception $dberr){
    
  }

}

//PRODUCT BY CATEGORY
if(isset($_POST['category']) && (!empty($_POST['category']))){
  $category=mysqli_real_escape_string($db_connection,$_POST['category']);
  $products=array();
  try{
    $products_query="SELECT * FROM products where category='".$category."'";
    
    $run_query=mysqli_query($db_connection,$products_query);
    while($res=mysqli_fetch_array($run_query)){
      $products[]=array(
        
        'id'=>$res['productCode'],
        'title'=>$res['title'],
        'price'=>$res['price'],
        'quantity'=>(int)$res['quantity'],
        'description'=>$res['description'],
        'isPreorder'=>$res['isPreorder']==0?'No':'Yes',
        'views'=>(int) $res['views'],
        'image'=>$res['productImage'],
        'category'=>$res['category'],
         'bulk_desc'=>$res['bulk_description'],
        'bulk_price'=>$res['bulk_price']
        
      );
    


    }
echo json_encode($products,JSON_UNESCAPED_SLASHES);
  }catch(Exception $dberr){
    
  }  

}
if(isset($_POST['similar']) && (!empty($_POST['similar']))){
  $category=mysqli_real_escape_string($db_connection,$_POST['similar']);
  $products=array();
  try{
    $products_query="SELECT * FROM products where category='".$category."' LIMIT 10";
    
    $run_query=mysqli_query($db_connection,$products_query);
    while($res=mysqli_fetch_array($run_query)){
      $products[]=array(
        
        'id'=>$res['productCode'],
        'title'=>$res['title'],
        'price'=>$res['price'],
        'quantity'=>(int)$res['quantity'],
        'description'=>$res['description'],
        'isPreorder'=>$res['isPreorder']==0?'No':'Yes',
        'views'=>(int) $res['views'],
        'image'=>$res['productImage'],
        'category'=>$res['category'],
         'bulk_desc'=>$res['bulk_description'],
        'bulk_price'=>$res['bulk_price']
      );
    


    }
echo json_encode($products,JSON_UNESCAPED_SLASHES);
  }catch(Exception $dberr){
    
  }  

}

//HOME Products

if(isset($_GET['home'])){

  $productsByCategory=array();
  $homeProducts=array();
  $catQuery="SELECT * FROM categories";
  $catResult=mysqli_query($db_connection,$catQuery);
  while ($row=mysqli_fetch_array($catResult)){
    $products="select * from products where category=".'"'.$row['title'].'"'." order by RAND() LIMIT 10";
    $productsQuery=mysqli_query($db_connection,$products);
    while($res=mysqli_fetch_array($productsQuery)){
      $productsByCategory[]=array(
        
        'id'=>$res['productCode'],
        'title'=>$res['title'],
        'price'=>$res['price'],
        'quantity'=>(int)$res['quantity'],
        'description'=>$res['description'],
        'isPreorder'=>$res['isPreorder']==0?'No':'Yes',
        'views'=>(int) $res['views'],
        'image'=>$res['productImage'],
        'category'=>$res['category'],
         'bulk_desc'=>$res['bulk_description'],
        'bulk_price'=>$res['bulk_price']

      );
  
    }

    $homeProducts[]=array(
      'category'=>$row['title'],
      'products'=>$productsByCategory
    );

    $productsByCategory=[];
  }

  echo json_encode($homeProducts);
  
}

//GET SEARCH PRODUCT
if(isset($_POST['search']) && (!empty($_POST['search']))){
  $products=array();
  try{
    $products_query="SELECT * FROM products WHERE title LIKE '%".$_POST['search']."%' LIMIT 9";
    $run_query=mysqli_query($db_connection,$products_query);
    while($res=mysqli_fetch_array($run_query)){
      $products[]=array(      
        'id'=>$res['productCode'],  
        'title'=>$res['title'],
        'price'=>$res['price'],
        'quantity'=>(int)$res['quantity'],
        'description'=>$res['description'],
        'isPreorder'=>$res['isPreorder']==0?'No':'Yes',
        'views'=>(int) $res['views'],
        'image'=>$res['productImage'],
        'category'=>$res['category'],
        'bulk_desc'=>$res['bulk_description'],
        'bulk_price'=>$res['bulk_price']
        
      );
    
  }
//print_r($products);

  echo json_encode($products);
}catch(Exception $dberr){
  
  
}

}

if(isset($_POST['searchPage']) && (!empty($_POST['searchPage']))){
  $products=array();
  try{
    $products_query="SELECT * FROM products WHERE title LIKE '%".$_POST['searchPage']."%'";
    $run_query=mysqli_query($db_connection,$products_query);
    while($res=mysqli_fetch_array($run_query)){
      $products[]=array(      
        'id'=>$res['productCode'],  
        'title'=>$res['title'],
        'price'=>$res['price'],
        'quantity'=>(int)$res['quantity'],
        'description'=>$res['description'],
        'isPreorder'=>$res['isPreorder']==0?'No':'Yes',
        'views'=>(int) $res['views'],
        'image'=>$res['productImage'],
        'category'=>$res['category'],
        'bulk_desc'=>$res['bulk_description'],
        'bulk_price'=>$res['bulk_price']
      );
    
  }
//print_r($products);

  echo json_encode($products);
}catch(Exception $dberr){
  
}

}




?>