<?php
include('Db_connection.php');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET,HEAD,OPTIONS,POST,PUT");
header("Access-Control-Allow-Headers: *");

$status;

// -------------------------
// Audit logging function
// -------------------------
function logAudit($db_connection, $action, $entity, $entity_id = null, $performed_by = null, $details = null) {
    $stmt = $db_connection->prepare("INSERT INTO audit_trail (action, entity, entity_id, performed_by, details) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("sssss", $action, $entity, $entity_id, $performed_by, $details);
    $stmt->execute();
    $stmt->close();
}

// -------------------------
// Get Users
// -------------------------
if(isset($_GET['users'])){ 
    $users = array();
    try{
        $users_query = "SELECT * FROM users";
        $run_query = mysqli_query($db_connection, $users_query);
        while($res = mysqli_fetch_array($run_query)){
            $users[] = array(     
                'id'=>$res['userId'],
                'name'=>$res['name'],
                'sysId'=>$res['username'],
                'access'=>$res['role'],
                'email'=>$res['email'],  
                'telephone'=>$res['tel'],
                'key'=> $res['id'],
                'lastActive'=>$res['date_modified'],
                'dateAdded'=>$res['date_created'],
                'initials'=>$res['initials']
            );
        }
        echo json_encode($users,JSON_UNESCAPED_SLASHES);
    }catch(Exception $dberr){ }
}

// -------------------------
// Get Users Count
// -------------------------
if(isset($_GET['userCount'])){ 
    $userCount;
    try{
        $users_query = "SELECT count(*) as num FROM users";
        $run_query = mysqli_query($db_connection, $users_query);
        while($res = mysqli_fetch_array($run_query)){
            $userCount = $res['num'];
        }
        echo json_encode($userCount,JSON_UNESCAPED_SLASHES);
    }catch(Exception $dberr){ }  
}

// -------------------------
// User Login (with audit logging)
// -------------------------
if(isset($_POST['userLogin']) && !empty($_POST['userLogin'])){
    $username = mysqli_real_escape_string($db_connection, $_POST['userLogin']['username'] ?? ''); 
    $password = mysqli_real_escape_string($db_connection, $_POST['userLogin']['password'] ?? '');
    $password_hashed = sha1(md5($password));

    if(!empty($password_hashed) && !empty($username)){
        try{
            $outUsername = null;
            $outuserRole = null;
            $outuserInitials = null;
            $userId = null;

            $users_query = "SELECT userId, name, role, initials FROM users WHERE username='$username' AND password='$password_hashed'";
            $run_query = mysqli_query($db_connection, $users_query);
            while($res = mysqli_fetch_array($run_query)){
                $userId = $res['userId'];
                $outUsername = $res['name'];
                $outuserRole = $res['role'];
                $outuserInitials = $res['initials'];
            }

            if(!empty($outUsername) && !empty($outuserRole)){
                // Successful login
                echo json_encode([
                    'success' => true,
                    'user' => [
                        'username' => $outUsername, 
                        'role' => $outuserRole, 
                        'initials' => $outuserInitials
                    ]
                ], JSON_UNESCAPED_SLASHES);

                logAudit($db_connection, 'login_success', 'user', $userId, $username);
            } else {
                // Failed login
                echo json_encode([
                    'success' => false,
                    'message' => 'Invalid credentials'
                ], JSON_UNESCAPED_SLASHES);

                logAudit($db_connection, 'login_failed', 'user', null, $username);
            }
        } catch(Exception $dberr){
            echo json_encode([
                'success' => false,
                'message' => 'Login error'
            ], JSON_UNESCAPED_SLASHES);

            logAudit($db_connection, 'login_failed', 'user', null, $username, 'DB error');
        }
    }
}

// -------------------------
// Create User
// -------------------------
if(isset($_POST['newUser'])&&!empty($_POST['newUser'])){
    $sysId=mysqli_real_escape_string($db_connection,$_POST['newUser']['sysId']); 
    $name=mysqli_real_escape_string($db_connection,$_POST['newUser']['name']);
    $email=mysqli_real_escape_string($db_connection,$_POST['newUser']['email']);
    $tel=mysqli_real_escape_string($db_connection,$_POST['newUser']['tel']);
    $role=mysqli_real_escape_string($db_connection,$_POST['newUser']['role']);
    $initials=mysqli_real_escape_string($db_connection,$_POST['newUser']['initials']);
    $userId=sha1(md5($sysId));
    $password=sha1(md5("temppass123"));
    try{
        $stmnt=$db_connection->prepare("INSERT INTO users(name, username, role, userId,password,email,tel,initials) VALUES (?,?,?,?,?,?,?,?)");
        $stmnt->bind_param("ssssssss",$name,$sysId,$role,$userId,$password,$email,$tel,$initials);
        $stmnt->execute();
        $status=1;
        $stmnt->close();

        logAudit($db_connection, 'create', 'user', $userId, $sysId);
    }catch(Exception $dberr){
        if($dberr->getCode()==1062){ $status=-1; }
        else{ $status=0; }
    }
    echo json_encode(array('status'=>$status));
}

// -------------------------
// Edit User
// -------------------------
if(isset($_POST['putUser'])&&!empty($_POST['putUser'])){
    $userId=mysqli_real_escape_string($db_connection,$_POST['putUser']['userId']); 
    $name=mysqli_real_escape_string($db_connection,$_POST['putUser']['name']);
    $email=mysqli_real_escape_string($db_connection,$_POST['putUser']['email']);
    $tel=mysqli_real_escape_string($db_connection,$_POST['putUser']['tel']);
    $role=mysqli_real_escape_string($db_connection,$_POST['putUser']['role']);
    $initials=mysqli_real_escape_string($db_connection,$_POST['putUser']['initials']);
    try{
        $stmnt=$db_connection->prepare("UPDATE users SET name=?,role=?,email=?,tel=?,initials=? WHERE userId=?");
        $stmnt->bind_param("ssssss",$name,$role,$email,$tel,$initials,$userId);
        $stmnt->execute();
        $status=1;
        $stmnt->close();

        logAudit($db_connection, 'update', 'user', $userId, $userId);
    }catch(Exception $dberr){
        if($dberr->getCode()==1062){ $status=-1; }
        else{ $status=0; }
    }
    echo json_encode(array('status'=>$status));
}

// -------------------------
// Delete User
// -------------------------
if(isset($_POST['deleteUser'])&&!empty($_POST['deleteUser'])){
    $userId=mysqli_real_escape_string($db_connection,$_POST['deleteUser']); 
    try{
        $stmnt=$db_connection->prepare("DELETE FROM users WHERE userId=?");
        $stmnt->bind_param("s",$userId);
        $stmnt->execute();
        $status=1;
        $stmnt->close();

        logAudit($db_connection, 'delete', 'user', $userId, $userId);
    }catch(Exception $dberr){ $status=0; }
    echo json_encode(array('status'=>$status));
}

// -------------------------
// Reset Password
// -------------------------
if(isset($_POST['changePassword'])&&!empty($_POST['changePassword'])){
    $userId=mysqli_real_escape_string($db_connection,$_POST['changePassword']); 
    $password=sha1(md5('temppass123'));
    try{
        $stmnt=$db_connection->prepare("UPDATE users SET password=? WHERE userId=?");
        $stmnt->bind_param("ss",$password,$userId);
        $stmnt->execute();
        $status=1;
        $stmnt->close();

        logAudit($db_connection, 'reset_password', 'user', $userId, $userId);
    }catch(Exception $dberr){ $status=0; }
    echo json_encode(array('status'=>$status));
}

// -------------------------
// Change Password
// -------------------------
if(isset($_POST['passChange'])&&!empty($_POST['passChange'])){
    $username=mysqli_real_escape_string($db_connection,$_POST['passChange']['username']??''); 
    $currentPassword=mysqli_real_escape_string($db_connection,$_POST['passChange']['currentPassword']??'');
    $newPassword=mysqli_real_escape_string($db_connection,$_POST['passChange']['newPassword']??'');
    $currentPassword=sha1(md5($currentPassword));
    $newPassword=sha1(md5($newPassword));

    $userId = null;
    if(!empty($currentPassword) && !empty($username) && !empty($newPassword)){
        try{
            $users_query="SELECT userId FROM users WHERE username='$username' AND password='$currentPassword'";
            $run_query=mysqli_query($db_connection,$users_query);
            while($res=mysqli_fetch_array($run_query)){
                $userId=$res['userId'];
            }

            if(!empty($userId)){
                $stmnt=$db_connection->prepare("UPDATE users SET password=? WHERE userId=?");
                $stmnt->bind_param("ss",$newPassword,$userId);
                $stmnt->execute();
                $stmnt->close();

                logAudit($db_connection, 'change_password', 'user', $userId, $username);

                echo json_encode(['success' => true,'message'=>'passwordChanged'],JSON_UNESCAPED_SLASHES);
            } else {
                logAudit($db_connection, 'change_password_failed', 'user', null, $username, 'Wrong current password');
                echo json_encode(['success' => false,'message'=>'Invalid credentials'],JSON_UNESCAPED_SLASHES);
            }

        } catch(Exception $dberr){
            logAudit($db_connection, 'change_password_failed', 'user', null, $username, 'DB error');
            echo json_encode(['success' => false,'message'=>'Invalid credentials'],JSON_UNESCAPED_SLASHES);
        }
    }
}  
?>
